/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Color;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.plugin.jei.IRecipeTooltipReplacement;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientHelper;
import slimeknights.tconstruct.plugin.jei.entity.EntityIngredientRenderer;
import slimeknights.tconstruct.plugin.jei.fabric.JEITypes;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;

public class EntityMeltingRecipeCategory
implements IRecipeCategory<EntityMeltingRecipe> {
    public static final class_2960 BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/melting.png");
    private static final class_2561 TITLE = TConstruct.makeTranslation("jei", "entity_melting.title");
    private static final String KEY_PER_HEARTS = TConstruct.makeTranslationKey("jei", "entity_melting.per_hearts");
    private static final class_2561 TOOLTIP_PER_HEART = class_2561.method_43471((String)TConstruct.makeTranslationKey("jei", "entity_melting.per_heart")).method_27692(class_124.field_1080);
    private static final Int2ObjectMap<IRecipeSlotTooltipCallback> TOOLTIP_MAP = new Int2ObjectOpenHashMap();
    private final EntityIngredientRenderer entityRenderer = new EntityIngredientRenderer(32);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrow;
    private final IDrawable tank;

    public EntityMeltingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 41, 150, 62);
        this.icon = helper.createDrawable(BACKGROUND_LOC, 174, 41, 16, 16);
        this.arrow = helper.drawableBuilder(BACKGROUND_LOC, 150, 41, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tank = helper.createDrawable(BACKGROUND_LOC, 150, 74, 16, 16);
    }

    public RecipeType<EntityMeltingRecipe> getRecipeType() {
        return TConstructJEIConstants.ENTITY_MELTING;
    }

    public class_2561 getTitle() {
        return TITLE;
    }

    public void draw(EntityMeltingRecipe recipe, IRecipeSlotsView slot, class_332 graphics, double mouseX, double mouseY) {
        this.arrow.draw(graphics, 71, 21);
        String damage = Float.toString((float)recipe.getDamage() / 2.0f);
        class_327 fontRenderer = class_310.method_1551().field_1772;
        int x = 84 - fontRenderer.method_1727(damage);
        graphics.method_51433(fontRenderer, damage, x, 8, Color.RED.getRGB(), false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EntityMeltingRecipe recipe, IFocusGroup focuses) {
        List<class_1299> displayTypes = EntityIngredientHelper.applyFocus(RecipeIngredientRole.INPUT, recipe.getEntityInputs(), focuses);
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 11).setCustomRenderer(TConstructJEIConstants.ENTITY_TYPE, (IIngredientRenderer)this.entityRenderer).addIngredients(TConstructJEIConstants.ENTITY_TYPE, displayTypes);
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(recipe.getItemInputs());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 115, 11).setFluidRenderer(18000L, false, 16, 32).addTooltipCallback((IRecipeSlotTooltipCallback)TOOLTIP_MAP.computeIfAbsent(recipe.getDamage(), FluidTooltip::new)).addIngredient(JEITypes.FLUID_STACK, (Object)recipe.getOutput());
        builder.addSlot(RecipeIngredientRole.CATALYST, 75, 43).setFluidRenderer(1L, false, 16, 16).setOverlay(this.tank, 0, 0).addTooltipCallback((IRecipeSlotTooltipCallback)IRecipeTooltipReplacement.EMPTY).addIngredients(JEITypes.FLUID_STACK, MeltingFuelHandler.getUsableFuels(1));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    private record FluidTooltip(int damage) implements IRecipeTooltipReplacement
    {
        @Override
        public void addMiddleLines(IRecipeSlotView recipeSlotView, List<class_2561> list) {
            recipeSlotView.getDisplayedIngredient(JEITypes.FLUID_STACK).ifPresent(fluid -> FluidTooltipHandler.appendMaterial(fluid, list));
            if (this.damage == 2) {
                list.add(TOOLTIP_PER_HEART);
            } else {
                list.add((class_2561)class_2561.method_43469((String)KEY_PER_HEARTS, (Object[])new Object[]{Float.valueOf((float)this.damage / 2.0f)}).method_27692(class_124.field_1080));
            }
        }
    }
}

